function [fopt,xopt,gopt]=Gradient_F(Oracle,xini)


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//     RESOLUTION D'UN PROBLEME D'OPTIMISATION SANS CONTRAINTES              //
//                                                                           //
//     Methode du gradient a pas fixe                                        //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


// ------------------------
// Parametres de la methode
// ------------------------

   titre = "Parametres du gradient a pas fixe";
   labels = ["Nombre maximal d''iterations";...
             "Valeur du pas de gradient";...
             "Seuil de convergence sur ||G||"];
   typ = list("vec",1,"vec",1,"vec",1);
   default = ["5000";"0.0005";"0.000001"];
   [ok,iter,alphai,tol] = getvalue(titre,labels,typ,default);

// ----------------------------
// Initialisation des variables
// ----------------------------

   x = xini;
   
   logG = [];
   logP = [];
   Cout = [];

// -------------------------
// Boucle sur les iterations
// -------------------------

   timer();

   kstar = iter;
   for k = 1:iter

//    - valeur du critere et du gradient

      ind = 4;
      [F,G] = Oracle(x,ind);

//    - test de convergence

      if norm(G) <= tol then
         kstar = k;
         break
      end

//    - calcul de la direction de descente

      D = -G;

//    - calcul de la longueur du pas de gradient

      alphan = alphai;

//    - mise a jour des variables

      x = x + (alphan*D);

//    - evolution du gradient, du pas et du critere

      logG = [ logG ; log10(norm(G)) ];
      logP = [ logP ; log10(alphan) ];
      Cout = [ Cout ; F ];

   end

   tcpu = timer();

// ---------------------------
// Resultats de l'optimisation
// ---------------------------

   fopt = F;
   xopt = x;
   gopt = G;

// - valeurs en fin d'algorithme

   cvge = ['Iteration         : ' string(kstar);...
           'Temps CPU         : ' string(tcpu);...
           'Critere optimal   : ' string(fopt);...
           'Norme du gradient : ' string(norm(gopt))];
   disp('Fin de la methode de gradient a pas fixe')
   disp(cvge)

// - visualisation de la convergence

   Visualg(logG,logP,Cout);

endfunction
