function []=Visualg(logG,logP,Cout)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                           %
%   VISUALISATION DES ITEREES D'UN ALGORITHME               %
%                                                           %
% Affichage des resultats obtenus durant l'algorithme       %
%                                                           %
%   - logG : tableau contenant le log base 10 de la norme   %
%            du gradient du critere pour chaque iteration   %
%            de l'algorithme d'optimisation.                %
%   - logP : tableau contenant le log base 10 du pas de     %
%            gradient pour chaque iteration.                %
%   - Cout : tableau contenant la valeur du critere pour    %
%            chaque iteration.                              %
%                                                           %
% L'affichage du cout est probablement le moins interessant %
% et peut etre omis. Afficher le log en base 10 de la norme %
% du gradient permet bien representer la convergence vers 0 %
% du gradient. Enfin,  afficher le log en base 10 du pas de %
% descente donne par l'algorithme de recherche lineaire est %
% un bon  moyen de verifier que cet algorithme de recherche %
% lineaire fonctionne de maniere satisfaisante.             %
%                                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


numwin = 10;
typvis =  1;

nlig = size(logG, 1);
ncol = size(logG,2);
absX = 1:nlig';

if typvis == 0
    
    %
    % Affichage des 3 graphiques, un par fenetre
    %
    
    figure(numwin);
    clf(numwin);
    plot(logG);
    xtitle('Norme du gradient (echelle logarithmique)','Iter.','log||G||');
    
    numwin = numwin + 1;
    figure(numwin);
    clf(numwin);
    plot(logP);
    xtitle('Pas de gradient (echelle logarithmique)','Iter.','log(alpha)');
    
    numwin = numwin + 1;
    figure(numwin);
    clf(numwin);
    plot(Cout);
    xtitle('Evolution du critere','Iter.','Cout');
    
else
    
    %
    % Affichage de 2 graphiques sur une meme fenetre
    %
    
    figure(numwin);hold on;
    
    clf(numwin);
    
    
    
    sp1= subplot(2,1,1);
    hold on;
    sp1.XLabel.String='Itrations';
    sp1.YLabel.String='||G||';
    
    sp1.Title.String= 'Norme de gradient  l chelle logarithmique';
    sp1.FontSize=14;
    sp1.FontWeight='bold';
    sp1.XGrid='on';
    sp1.YGrid='on';
    sp1.Title.FontSize=18;
    
    plot(sp1,absX,logG, 'Linewidth', 3);
     
    sp2= subplot(2,1,2);hold on;
    sp2.XLabel.String='Itrations';
    sp2.YLabel.String='\alpha';
  
    sp2.Title.String=' Pas \alpha';
    
    
    sp2.FontSize=14;
    sp2.FontWeight='bold';
    sp2.XGrid='on';
    sp2.YGrid='on';
    sp2.Title.FontSize=18;
    
    plot(sp2,absX,logP, 'Linewidth', 3);
  
    
end

end
