function [fopt,xopt,gopt]=Gradient_F(Oracle,xini)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                           %
%         RESOLUTION D'UN PROBLEME D'OPTIMISATION SANS CONTRAINTES          %
%                                                                           %
%         Methode de gradient a pas fixe                                    %
%                                                                           %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% ------------------------
% Parametres de la methode
% ------------------------

[iter,alphai,tol, ok] = mainMenu;

% ----------------------------
% Initialisation des variables
% ----------------------------

logG = [];
logP = [];
Cout = [];

if(ok==1)
    tic;
    
    % -------------------------
    % Boucle sur les iterations
    % -------------------------
    
    x = xini;
    
    kstar = iter;
    for k = 1:iter
        
        % Valeur du critere et du gradient
        
        ind = 4;
        [F,G] = Oracle(x,ind);
        
        % Test de convergence
        
        if norm(G) <= tol
            kstar = k;
            break;
        end
        
        % Calcul de la direction de descente
        
        D = -G;
        
        % Calcul de la longueur du pas de gradient
        
        alphan = alphai;
        
        % Mise a jour des variables
        
        x = x + (alphan*D);
        
        % Evolution du gradient, du pas et du critere
        
        logG = [ logG ; log10(norm(G)) ];
        logP = [ logP ; log10(alphan) ];
        Cout = [ Cout ; F ];
        
    end
    
    % ---------------------------
    % Resultats de l'optimisation
    % ---------------------------
    
    fopt = F;
    xopt = x;
    gopt = G;
    
    tcpu = toc;
    fprintf('=============================================================\n');
    fprintf('                      Rsultats du calcul                    \n');
    fprintf('=============================================================\n');
    fprintf('Iteration         : %d\n',kstar);
    fprintf('Temps CPU         : %d\n',tcpu);
    fprintf('Critere optimal   : %f\n',fopt);
    fprintf('Norme du gradient : %f\n',norm(gopt));
    fprintf('Fin de la methode de gradient a pas fixe.\n');
    
    fprintf('=============================================================\n');
    
    % Visualisation de la convergence
    
    Visualg(logG,logP,Cout);
    
else
    fprintf('=============================================================\n');
    fprintf('Abandon\n');
    fprintf('=============================================================\n');
    x=xini;
    ind = 4;
    [F,G] = Oracle(x,ind);
    fopt = F;
    xopt = x;
    gopt = G;
end
end
