#############################################################################
#                                                                           #
#   RECHERCHE LINEAIRE SUIVANT LES CONDITIONS DE WOLFE                      #
#   (Algorithme de Fletcher-Lemarechal)                                     #
#                                                                           #
#############################################################################

#  Arguments en entree                                    
#  -------------------                                    
#    alpha  : valeur initiale du pas                      
#    x      : valeur initiale des variables               
#    F      : valeur du critere au point x                
#    G      : valeur du gradient au point x               
#    D      : direction de descente                       
#    Oracle : nom de la fonction Oracle                   
#                                                         
#  Arguments en sortie                                    
#  -------------------                                    
#    alphan : valeur du pas apres recherche lineaire
#
#
#    ok     : indicateur de reussite de la recherche      
#             = 1 : conditions de Wolfe verifiees         
#             = 2 : indistinguabilite des iteres          
#                                                         
#    omega1 : coefficient pour la 1-ere condition de Wolfe
#    omega2 : coefficient pour la 2-eme condition de Wolfe


function Wolfe(alpha, x, D, Oracle)

    ##### Coefficients de la recherche lineaire

    omega1 = 0.1
    omega2 = 0.9

    alphamin = 0.0
    alphamax = Inf

    ok = 0
    dltx = 0.00000001

    ##### Algorithme de Fletcher-Lemarechal

    # Appel de l'oracle au point initial
    F, G = Oracle(x)

    # Initialisation de l'algorithme
    alphan = alpha
    xn = copy(x)
    xp = copy(x)
    Gn = zeros(Float64, length(x))
    
    # Boucle de calcul du pas
    # xn represente le point pour la valeur courante du pas,
    # xp represente le point pour la valeur precedente du pas.
    while ok == 0
	
        # Point precedent pour tester l'indistinguabilite
        xp[:] = xn

        # Point actuel
        xn[:] = x .+ alphan*D

        # Calcul des conditions de Wolfe
        #
        # ---> A completer...
        # ---> A completer...
        
        # Test des conditions de Wolfe
        #
        # - Si les deux conditions de Wolfe sont verifiees,
        #   poser ok = 1 : on sort alors de la boucle while
        # - Sinon, modifier la valeur de alphan et reboucler
        #
        # ---> A completer...
        # ---> A completer...
	
        #  Test d'indistingabilite
        if norm(xn-xp) < dltx
            ok = 2
        end
    end

    return alphan
end
