#############################################################################
#                                                                           #
# REPRESENTATION GRAPHIQUE DE LA CONVERGENCE DE LA METHODE D'OPTIMISATION   #
#                                                                           #
#############################################################################


function Visualg(logG, logP, cout)

  # Dimension des tableaux et abscisses

  ndim = length(logG)

  abs = collect(1:ndim)'

  # Type du graphique

  typaff = "two"

  # Affichage

  figC = figure()

  if typaff == "one"
  
      plot(abs, logG, label="Norme du gradient (log10)")
      xlabel("Iterations")
      ylabel("log10(||G||)")
      legend()
      title("Evolution du gradient au cours des iterations")
      grid("on")
      #savefig("NormG.pdf")

  elseif typaff == "two"
  
      subplot(211)
      plot(abs, logG, label="Norme du gradient (log10)")
      ylabel("log10(||G||)")
      #title("Evolution du gradient au cours des iterations")
      grid("on")
      
      subplot(212)
      plot(abs, logP, label="Longueur du pas (log10)")
      ylabel("log10(rho)")
      #title("Evolution du pas de gradient au cours des iterations")
      grid("on")
      
      suptitle("Evolution de la methode au cours des iterations")
      
  else
  
      subplot(311)
      plot(abs, logG, label="Norme du gradient (log10)")
      ylabel("log10(||G||)")
      #title("Evolution du gradient au cours des iterations")
      grid("on")
      
      subplot(312)
      plot(abs, logP, label="Longueur du pas (log10)")
      ylabel("log10(rho)")
      #title("Evolution du pas de gradient au cours des iterations")
      grid("on")
      
      subplot(313)
      plot(abs, cout, label="Critere")
      ylabel("Cout")
      #title("Evolution du critere au cours des iterations")
      grid("on")
      
      suptitle("Evolution de la methode au cours des iterations")

      # ce qui suit ne sert apparemment a rien...
      plot(reuse=false)
      
  end

end
