#############################################################################
#                                                                           #
# VERIFICATION DES EQUATIONS D'EQUILIBRE D'UN RESEAU DE DISTRIBUTION D'EAU  #
#                                                                           #
#############################################################################

# On suppose determinee la solution du probleme d'equilibre du reseau,
# et on calcule le plus grand ecart sur les 2 series d'equations qui
# caracterisent l'equilibre.
#
# Variables en entree
# -------------------
#    - q    : vecteur des debits des arcs
#    - z    : vecteur des pertes de charge des arcs
#    - f    : vecteur des flux des noeuds
#    - p    : vecteur des pressions des noeuds


function Verification(q, z, f, p)

  # Ecarts maximaux sur les lois de Kirchhoff
  tol1 = maximum(abs.(A*q-f))
  tol2 = maximum(abs.(A'*p+z))

  # Affichage alphanumerique
  println()
  println("Verification des lois de Kirchhoff")
  println(" - sur les debits    : ", tol1)
  println(" - sur les pressions : ", tol2)
  
end
