#############################################################################
#                                                                           #
#  MONITEUR D'ENCHAINEMENT POUR LE CALCUL DE L'EQUILIBRE D'UN RESEAU D'EAU  #
#                                                                           #
#############################################################################

using LinearAlgebra
using PyPlot


############################################################
#####                                                  #####
#####   Le cas d'un reseau realiste de taille normale  #####
#####                                                  #####
############################################################

##### Fonctions fournies dans le cadre du projet

# Probleme realiste et structures normales
include("Probleme_R.jl")
include("Structures_N.jl")

# Affichage des resultats
include("Visualg.jl")

# Optimisation
include("Gradient_F.jl")
include("Newton_F.jl")

# Verification des resultats
include("HydrauliqueP.jl")
include("HydrauliqueD.jl")
include("Verification.jl")

##### Fonctions a ecrire dans le cadre du projet

# ---> Charger les fonctions associees a l'oracle du probleme,
#      aux algorithmes d'optimisation et de recherche lineaire
#
#      Exemple 1 - tester l'oracle sur le gradient a pas fixe :
#
#          include("OraclePG.jl")
#          include("Gradient_F.jl")
#
#      Exemple 2 - ecrire le gradient a pas variable :
#
#          include("OraclePG.jl")
#          include("Wolfe.jl")
#          include("Gradient_V.jl")
#
# ---> A modifier...
# ---> A modifier...
# ---> A modifier...

##### Initialisation de l'algorithme

# ---> La dimension du vecteur dans l'espace primal est n-md
#      et la dimension du vecteur dans l'espace dual est md
#
#      Probleme primal :
#
#          x0 = 0.1 * rand(n-md)
#
#      Probleme dual :
#
#          x0 = 100 .+ rand(md)
#
# ---> A modifier...
# ---> A modifier...
# ---> A modifier...

##### Minimisation proprement dite

# ---> Executer la fonction d'optimisation choisie
#
#      Exemple 1 - le gradient a pas fixe :
#
#          println()
#          println("ALGORITHME DU GRADIENT A PAS FIXE")
#          copt, gopt, xopt = Gradient_F(OraclePG, x0, 0.0005)
#
#      Exemple 2 - le gradient a pas variable :
#
#          println()
#          println("ALGORITHME DU GRADIENT A PAS VARIABLE")
#          copt, gopt, xopt = Gradient_V(OraclePG, x0, 1.0)
#
# ---> A modifier...
# ---> A modifier...
# ---> A modifier...

##### Verification des resultats

# ---> La fonction qui reconstitue les variables hydrauliques
#      du reseau a partir de la solution du probleme s'appelle
#      HydrauliqueP pour le probleme primal, et HydrauliqueD
#      pour le probleme dual
#
#      Probleme primal :
#
#          qopt, zopt, fopt, popt = HydrauliqueP(xopt)
#          Verification(qopt, zopt, fopt, popt)
#
#      Probleme dual :
#
#          qopt, zopt, fopt, popt = HydrauliqueD(xopt)
#          Verification(qopt, zopt, fopt, popt)
#
# ---> A modifier...
# ---> A modifier...
# ---> A modifier...
