#############################################################################
#                                                                           #
#       STRUCTURES ASSOCIEES A LA RESOLUTION DES EQUATIONS Du RESEAU        #
#                                                                           #
#     Structures_N : utilisation de matrices pleines                        #
#                                                                           #
#############################################################################


#############################################################################
#
# Structures du probleme
# ----------------------
#
# A partir des deux vecteurs contenant  respectivement les noeuds initiaux et
# finaux des arcs, on construit la matrice d'incidence de graphe noeuds-arcs.
#
# De la sous-matrice extraite de la matrice d'incidence noeuds-arcs du graphe
# en supprimant les lignes  correspondant aux noeuds reservoirs (mr premieres
# lignes de cette matrice), on extrait le plus grand bloc carre et inversible
# (on suppose que les colonnes qui forment ce bloc correspondent aux premiers
#  arcs dans la numerotation du graphe).
#
# On calcule le vecteur des debits admissibles du reseau (c.a.d. satisfaisant
# la 1-iere loi de Kirchhoff) associe au vecteur des debits nuls du co-arbre.
#
#
# A    : matrice d'incidence noeuds-arcs du graphe        : M(m,n)
# Ar   : sous-matrice de A correspondant aux reservoirs   : M(mr,n)
# Ad   : sous-matrice complementaire de Ar pour A         : M(md,n)
# AdT  : plus grande sous-matrice carree inversible de Ad : M(md,md)
# AdI  : matrice inverse de AdT                           : M(md,md)
# AdC  : sous-matrice complementaire de AdT pour Ad       : M(md,n-md)
# B    : matrice d'incidence arcs-cycles du graphe        : M(n,n-md)
#
# q0   : vecteur des debits admissibles des arcs          : M(n,1)
#
#############################################################################

A = zeros(m, n)

for l = 1:n
    A[orig[l], l] = +1
    A[dest[l], l] = -1
end

Ar = A[1:mr, :]
Ad = A[mr+1:m, :]

AdT = Ad[:, 1:md]
AdI = inv(AdT)

AdC = Ad[:, md+1:n]

B = [-AdI * AdC ; I]

q0 = [AdI * fd; zeros(n-md)]
