#############################################################################
#                                                                           #
#    CALCUL DES VARIABLES HYDRAULIQUES DU RESEAU A PARTIR DES DEBITS        #
#                                                                           #
#############################################################################

# Supposant connus les debits des arcs du co-arbre, on calcule
# l'ensemble des variables hydrauliques du reseau ; on dispose
# pour cela des donnees et structures du probleme.
#
# Variables en entree
# -------------------
#    - qc   : vecteur des debits des arcs du co-arbre
#
# Variables en sortie
# -------------------
#    - q    : vecteur des debits des arcs
#    - z    : vecteur des pertes de charge des arcs
#    - f    : vecteur des flux des noeuds
#    - p    : vecteur des pressions des noeuds


function HydrauliqueP(qc)

  # Debit des arcs
    
  q = q0 + B*qc
    
  # Pertes de charge des arcs
    
  z = r .* abs.(q) .* q
    
  # Flux aux noeuds
    
  f = [Ar*q ; fd]
    
  # Pressions aux noeuds
    
  temp = (Ar'*pr) + z
    
  p = [pr; -AdI'*temp[1:md]]
    
  return q, z, f, p
  
end

