#############################################################################
#                                                                           #
#    CALCUL DES VARIABLES HYDRAULIQUES DU RESEAU A PARTIR DES PRESSIONS     #
#                                                                           #
#############################################################################

# Supposant connues les pressions aux noeuds de demande, on calcule
# l'ensemble des variables hydrauliques du reseau ; on dispose pour
# cela des donnees et structures du probleme.
#
# Variables en entree
# -------------------
#    - pd   : vecteur des pressions aux noeuds de demande
#
# Variables en sortie
# -------------------
#    - q    : vecteur des debits des arcs
#    - z    : vecteur des pertes de charge des arcs
#    - f    : vecteur des flux des noeuds
#    - p    : vecteur des pressions des noeuds


function HydrauliqueD(pd)

  # Pressions aux noeuds
  
  p = [pr ; pd]
  
  # Pertes de charge des arcs
  
  z = -A' * p
    
  # Debit des arcs
  
  q = z ./ sqrt.(r .* abs.(z))
    
  # Flux aux noeuds
    
  f = [Ar*q ; fd]
    
  return q, z, f, p
    
end
