#############################################################################
#                                                                           #
#         RESOLUTION D'UN PROBLEME D'OPTIMISATION SANS CONTRAINTES          #
#                                                                           #
#     Methode du gradient a pas fixe                                        #
#                                                                           #
#############################################################################


function Gradient_F(Oracle, xini, alpha0)

  ##### Initialisation des variables

  iter  = 10000
  alphai = alpha0
  tol   = 1e-6

  nx = length(x0)
  
  logG = Float64[]
  logP = Float64[]
  cout = Float64[]

  F = Inf
  G = zeros(Float64, nx)
  D = zeros(Float64, nx)

  x = copy(x0)

  ##### Boucle sur les iterations

  tic = time()

  kstar = iter
  for k = 1:iter

      # Appel de l'oracle 
      F, G = Oracle(x)

      # Test de convergence
      if norm(G) <= tol
          kstar = k
          break
      end

      # Direction de descente
      D = -G

      # Calcul du pas de gradient
      alphan = alphai

      # Mise a jour du point courant
      x = x + (alphan*D)

      # Evolution du gradient, du pas et du critere
      push!(logG, log10(norm(G)))
      push!(logP, log10(alphan))
      push!(cout, F)

  end

  ##### Resultats de l'optimisation
    
  fopt = F
  gopt = G
  xopt = x
  tcpu = time() - tic
    
  println()
  println("Iteration : ", kstar)
  println("Temps CPU : ", tcpu)
  println("Critere optimal : ", fopt)
  println("Norme du gradient : ", norm(G))

  # Visualisation de la convergence
  Visualg(logG, logP, cout)
    
  return fopt, gopt, xopt
    
end
