#include "tests.h"

class arithmetic_test : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(arithmetic_test);
  CPPUNIT_TEST(test_addition);
  CPPUNIT_TEST(test_subtraction);
  CPPUNIT_TEST(test_multiplication);
  CPPUNIT_TEST(test_division);
  CPPUNIT_TEST_SUITE_END();
public:
  void setUp() {
  }
  void tearDown() {
  }

  // --> Beginning of tests

  void test_addition() {
    TEST_SEQ(interval::universe+interval::universe,interval::universe);
    TEST_SEQ(max_inf+max_inf,max_inf);
    TEST_SEQ(m_inf_m_max+m_inf_m_max,m_inf_m_max);
    
    TEST_EMPTY(interval::emptyset+interval::emptyset);

    TEST_SEQ(m_min_zero+m_min_zero,2*m_min_zero);
    TEST_SEQ(m_min_zero+zero_min,m_min_min);
  }


  void test_subtraction() {
    TEST_SEQ(interval::universe-interval::universe,interval::universe);
    TEST_SEQ(interval(4,5)-interval(3,7),interval(-3,2));
  }

  void test_multiplication() {
    TEST_EMPTY(interval::emptyset*interval::emptyset);
    TEST_EMPTY(interval::emptyset*interval(4,5));
    TEST_EMPTY(interval(4,5)*interval::emptyset);
    TEST_EMPTY(interval::emptyset*interval::zero);
    TEST_EMPTY(interval::zero*interval::emptyset);
    TEST_EMPTY(interval::emptyset*3);
    TEST_EMPTY(3*interval::emptyset);
    TEST_EMPTY(interval::emptyset*0.0);
    TEST_EMPTY(0.0*interval::emptyset);
    
    TEST_SEQ(interval::universe*interval::universe,interval::universe);
  }


  void test_division() {
  }
  // <-- End of tests
};

GAOL_REGISTER_TEST(arithmetic_test)
