/* ============================================================================
 * D Y N I B E X - Example for a first validated simulation of discrete system
 * ============================================================================
 * Copyright   : ENSTA ParisTech
 * License     : This program can be distributed under the terms of the GNU LGPL.
 *               See the file COPYING.LESSER.
 *
 * Author(s)   : Julien Alexandre dit Sandretto and Alexandre Chapoutot
 * Created     : March 2020
 * Sponsored   : This research benefited from the support of the "Chair Complex Systems Engineering - Ecole Polytechnique,
 * THALES, DGA, FX, DASSAULT AVIATION, DCNS Research, ENSTA ParisTech, Telecom ParisTech, Fondation ParisTech and FDO ENSTA"
 * ---------------------------------------------------------------------------- */

#include "ibex.h"

using namespace ibex;

int main(){

const int n= 2;
Variable y(n);
IntervalVector yinit(n);
yinit[0] = Interval(1.0, 1.1);
yinit[1] = Interval(0.5, 0.6);

Function ydot = Function(y,Return(y[1],-y[0]));

ivp_discrete problem = ivp_discrete(ydot,0.0,yinit);

simulation simu = simulation(&problem,10.0,0.1);

simu.run_simulation();

//For an export in order to plot
simu.generate_python_plot("exp.py", 0, 1);
//simu.export_yn("all.txt");

return 0;

}
