/*                                                                           
**  fi_lib++  --- A fast interval library (Version 2.0)                     
**                                                                  
**  Copyright (C) 2001:                                                        
**                                                     
**  Werner Hofschuster, Walter Kraemer                               
**  Wissenschaftliches Rechnen/Softwaretechnologie (WRSWT)  
**  Universitaet Wuppertal, Germany                                           
**  Michael Lerch, German Tischler, Juergen Wolff von Gudenberg       
**  Institut fuer Informatik                                         
**  Universitaet Wuerzburg, Germany                                           
** 
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Library General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**  Library General Public License for more details.
**
**  You should have received a copy of the GNU Library General Public
**  License along with this library; if not, write to the Free
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/
#include <interval/stdfun/filib_consts.hpp>

namespace filib
{
	template<>
	double const filib_consts<double>::q_exem  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_exep  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_exmm  =  9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_exmp  =  4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_logm  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_logp  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_lgpm  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_lgpp  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_sqtm  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_sqtp  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_snhm  = 9007199254740982.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_snhp  =  4503599627370503.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_cshm  = 9007199254740984.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_cshp  = 4503599627370502.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_cthm  = 9007199254740981.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_cthp  = 4503599627370503.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_tnhm  = 9007199254740979.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_tnhp  = 4503599627370504.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_asnm  = 9007199254740982.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_asnp  = 4503599627370503.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_acsm  = 9007199254740974.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_acsp  = 4503599627370507.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_actm  = 9007199254740978.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_actp  = 4503599627370505.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_atnm  = 9007199254740977.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_atnp  = 4503599627370505.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_csnm  = 9007199254740969.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_csnp  = 4503599627370509.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_cctm  = 9007199254740972.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_cctp  = 4503599627370508.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_ctnm  = 9007199254740976.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_ctnp  = 4503599627370506.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_sinm  = 9007199254740979.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_sinp  = 4503599627370504.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_cosm  = 9007199254740979.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_cosp  = 4503599627370504.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_cotm = 9007199254740962.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_cotp = 4503599627370513.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_tanm = 9007199254740962.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_tanp = 4503599627370513.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_lg2m  = 9007199254740964.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_lg2p  = 4503599627370512.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_l10m = 9007199254740964.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_l10p = 4503599627370512.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_e2em  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_e2ep  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_e10m  = 9007199254740986.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_e10p  = 4503599627370501.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_pi     = 7074237752028440.0 / 2251799813685248.0;
	template<>
	double const filib_consts<double>::q_piha   = 7074237752028440.0 / 4503599627370496.0;  
	template<>
	double const filib_consts<double>::q_atnt = 1.807032e-8;
	template<>
	double const filib_consts<double>::q_ccsm  = 9007199254740969.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_ccsp  = 4503599627370509.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_minr   = 2.2250738585072013e-308; 
	template<>
	double const filib_consts<double>::q_mine   = -6231120794008786.0 / 8796093022208.0;
	template<>
	double const filib_consts<double>::q_sqra   = 1.3407807929942596e154;
	template<>
	double const filib_consts<double>::q_ctht   = 5.562684646268013e-309;
	template<>
	double const filib_consts<double>::q_ln2h   = 6243314768165359.0 / 18014398509481984.0;
	template<>
	double const filib_consts<double>::q_l10i   = 7823553867474190.0 / 18014398509481984.0;
	template<>
	double const filib_consts<double>::q_l2i    = 6497320848556798.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_l10    = 5184960683398422.0 / 2251799813685248.0;
	template<>
	double const filib_consts<double>::q_l2     = 6243314768165359.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_p2h    = 1267650600228229401496703205376.0; 
	template<>
	double const filib_consts<double>::q_p2mh   = 1.0/1267650600228229401496703205376.0;
	template<>
	double const filib_consts<double>::q_pi2i   = 5734161139222659.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_pi2d   = 5734161139222657.0 /  9007199254740992.0;
	template<>
	double const filib_consts<double>::q_pi2u   = 5734161139222660.0 /  9007199254740992.0;
	template<>
	double const filib_consts<double>::q_ext1 = 4503599627370496.0 / 81129638414606681695789005144064.0;
	template<>
	double const filib_consts<double>::q_ext2 = 7956568137163861.0 / 4398046511104.0;
	template<>
	double const filib_consts<double>::q_ex2a = 6243314768165359.0 / 8796093022208.0;   
	template<>
	double const filib_consts<double>::q_ex2b =-6548164193139965.0 / 8796093022208.0;  
	template<>
	double const filib_consts<double>::q_ex2c = 6237217781087072.0 / 8796093022208.0;   
	template<>
	double const filib_consts<double>::q_ext3 =-5267796835639521.0 / 140737488355328.0;
	template<>
	double const filib_consts<double>::q_ext4 =-5182419497180051.0 / 18014398509481984.0;
	template<>
	double const filib_consts<double>::q_ext5 = 8039593716390434.0 / 36028797018963968.0;
	template<>
	double const filib_consts<double>::q_extm = 5417578529509920.0 / 17592186044416.0;
	template<>
	double const filib_consts<double>::q_extn =-5412282753821250.0 / 17592186044416.0;
	template<>
	double const filib_consts<double>::q_exil = 6497320848556798.0 / 140737488355328.0;
	template<>
	double const filib_consts<double>::q_exl1 = 6243314767495168.0 / 288230376151711744.0;
	template<>
	double const filib_consts<double>::q_exl2 = 5756898648422637.0 / 2475880078570760549798248448.0;
	template<>
	double const filib_consts<double>::q_e10i = 7480317065143153.0 / 70368744177664.0;
	template<>
	double const filib_consts<double>::q_e1l1 = 5422874304708608.0 / 576460752303423488.0;
	template<>
	double const filib_consts<double>::q_e1l2 = 8417842974672045.0 / 9903520314283042199192993792.0;
	template<>
	double const filib_consts<double>::q_lgt1= 8461480639267491.0 / 9007199254740992.0;
	template<>
	double const filib_consts<double>::q_lgt2= 4794056848520430.0 / 4503599627370496.0;
	template<>
	double const filib_consts<double>::q_lgt3=-8731497847576004.0 / 144115188075855872.0;
	template<>
	double const filib_consts<double>::q_lgt4= 4647315538398936.0 / 72057594037927936.0;
	template<>
	double const filib_consts<double>::q_lgt5= 4503599627370496.0 / 40564819207303340847894502572032.0;
	template<>
	double const filib_consts<double>::q_lgt6= 3.60287970189639680E+016;
	template<>
	double const filib_consts<double>::q_at3i = 6004799503160661.0 / 18014398509481984.0;

	template<>
	double const filib_consts<double>::q_atna[7] = 
	{ 
		0.0,
		8960721713639278.0 / 36028797018963968.0,   /* =  0.24871... */
		8960721713639278.0 / 18014398509481984.0,   /* =  0.49742... */
		6720541285229458.0 /  9007199254740992.0,   /* =  0.74613... */
		8960721713639278.0 /  9007199254740992.0,   /* =  0.99484... */
		5600451071024549.0 /  4503599627370496.0,   /* =  1.24355... */
		6720541285229458.0 /  4503599627370496.0    /* =  1.49226... */
	};

	template<>
	double const filib_consts<double>::q_atnb[8] =
	{
		0,
		4503599627370496.0 / 36028797018963968.0,   /* =  0.12500... */
		7050717449407908.0 / 18014398509481984.0,   /* =  0.39139... */
		6454487157372003.0 /  9007199254740992.0,   /* =  0.71659... */
		5343484307627230.0 /  4503599627370496.0,   /* =  1.18649... */
		4642583338069965.0 /  2251799813685248.0,   /* =  2.06172... */
		5472919125137495.0 /  1125899906842624.0,   /* =  4.86093... */
		4503599627370496.0 /   562949953421312.0    /* =  8.00000... */
	};

	template<>
	double const filib_consts<double>::q_atnc[7] =
	{
		0,
		4575085335741456.0 / 18014398509481984.0,   /* =  0.25397... */
		4890523484394786.0 /  9007199254740992.0,   /* =  0.54296... */
		8326197945442628.0 /  9007199254740992.0,   /* =  0.92439... */
		6934969934934130.0 /  4503599627370496.0,   /* =  1.53987... */
		6633650527568543.0 /  2251799813685248.0,   /* =  2.94593... */
		7153270512133541.0 /   562949953421312.0    /* = 12.70676... */
	};

	template<>
	double const filib_consts<double>::q_atnd[6] =
	{
		-6004799503160653.0 / 18014398509481984.0,   /* = -0.33333... */
		7205759403717662.0 / 36028797018963968.0,   /* =  0.20000... */
		-5146970946471129.0 / 36028797018963968.0,   /* = -0.14286... */
		8006368526669049.0 / 72057594037927936.0,   /* =  0.11111... */
		-6546869189017288.0 / 72057594037927936.0,   /* = -0.09086... */
		5323534481176937.0 / 72057594037927936.0     /* =  0.07388... */
	};

	template<>
	double const filib_consts<double>::q_pih[7] =
	{   
		7074236338274304.0 / 4503599627370496.0,
		5929713453236224.0 / 18889465931478580854784.0,
		4930663257997312.0 / 79228162514264337593543950336.0,
		5376096463749120.0 / 2658455991569831745807614120560689152.0,
		4908338017992704.0 / 1393796574908163946345982392040522594123776.0,
		8111234717057024.0 / 187072209578355573530071658587684226515959365500928.0,
		5071617642201088.0 / 24519928653854221733733552434404946937899825954937634816.0
	};

	template<>
	double const filib_consts<double>::q_pi2p[3] = 
	{
		5734160907894784.0 / 9007199254740992.0,
		7762075350728704.0 / 302231454903657293676544.0,
		5957137356292096.0 / 20282409603651670423947251286016.0
	};

	template<>
	double const filib_consts<double>::q_exa[5] =
	{ 
		4503599627370496.0 / 9007199254740992.0,
		6004799503129925.0 / 36028797018963968.0,
		6004799503120717.0 / 144115188075855872.0,
		4803856372824746.0 / 576460752303423488.0,
		6405142946487772.0 / 4611686018427387904.0
	};

	template<>
	double const filib_consts<double>::q_exb[9] =
	{ 
		6004799503160660.0 / 36028797018963968.0,
		6004799503160579.0 / 144115188075855872.0,
		4803839602540513.0 / 576460752303423488.0,
		6405119470632951.0 / 4611686018427387904.0,
		7320136463514879.0 / 36893488147419103232.0,
		7320133978402734.0 / 295147905179352825856.0,
		6506931592885707.0 / 2361183241434822606848.0,
		5209762888694261.0 / 18889465931478580854784.0,
		7399039345524175.0 / 302231454903657293676544.0
	};

	template<>
	double const filib_consts<double>::q_exc[7] =
	{  
		6243314768165359.0 / 9007199254740992.0,
		8655072057804175.0 / 36028797018963968.0,
		7998985059213504.0 / 144115188075855872.0,
		5544473941095235.0 / 576460752303423488.0,
		6149018367931802.0 / 4611686018427387904.0,
		5682920491042682.0 / 36893488147419103232.0,
		9003657864540998.0 / 590295810358705651712.0
	};

	template<>
	double const filib_consts<double>::q_exd[7] =
	{  
		5866321739426347.0 / 4503599627370496.0,
		5969406588676713.0 / 2251799813685248.0,
		4581688875035812.0 / 2251799813685248.0,
		5274864252159260.0 / 4503599627370496.0,
		4858329517834534.0 / 9007199254740992.0,
		7457838753610334.0 / 36028797018963968.0,
		4906373811462869.0 / 72057594037927936.0
	};

	template<>
	double const filib_consts<double>::q_exld[32] =
	{
		4503599627370496.0 /                 4503599627370496.0,
		4602215617889600.0 /                 4503599627370496.0,
		4702991017412864.0 /                 4503599627370496.0,
		4805973110840128.0 /                 4503599627370496.0,
		4911210218475840.0 /                 4503599627370496.0,
		5018751718701440.0 /                 4503599627370496.0,
		5128648071143936.0 /                 4503599627370496.0,
		5240950840352448.0 /                 4503599627370496.0,
		5355712719992576.0 /                 4503599627370496.0,
		5472987557571008.0 /                 4503599627370496.0,
		5592830379701248.0 /                 4503599627370496.0,
		5715297417922816.0 /                 4503599627370496.0,
		5840446135085568.0 /                 4503599627370496.0,
		5968335252311936.0 /                 4503599627370496.0,
		6099024776549376.0 /                 4503599627370496.0,
		6232576028726656.0 /                 4503599627370496.0,
		6369051672525760.0 /                 4503599627370496.0,
		6508515743784768.0 /                 4503599627370496.0,
		6651033680544128.0 /                 4503599627370496.0,
		6796672353750528.0 /                 4503599627370496.0,
		6945500098633920.0 /                 4503599627370496.0,
		7097586746770880.0 /                 4503599627370496.0,
		7253003658850432.0 /                 4503599627370496.0,
		7411823758157120.0 /                 4503599627370496.0,
		7574121564787584.0 /                 4503599627370496.0,
		7739973230616128.0 /                 4503599627370496.0,
		7909456575025792.0 /                 4503599627370496.0,
		8082651121422400.0 /                 4503599627370496.0,
		8259638134547584.0 /                 4503599627370496.0,
		8440500658608960.0 /                 4503599627370496.0,
		8625323556245696.0 /                 4503599627370496.0,
		8814193548346688.0 /                 4503599627370496.0 
	};

	template<>
	double const filib_consts<double>::q_extl[32] =
	{ 
		0.0,
		7350732955350452.0 /   633825300114114700748351602688.0,
		8661065463685896.0 /  2535301200456458802993406410752.0,
		4684932057853331.0 /  1267650600228229401496703205376.0,
		8284200537303158.0 /   633825300114114700748351602688.0,
		5976957489595592.0 /   633825300114114700748351602688.0,
		7937791009590795.0 /   633825300114114700748351602688.0,
		4668607584775442.0 /   633825300114114700748351602688.0,
		5961452550906630.0 /  1267650600228229401496703205376.0,
		5996911069096105.0 /  2535301200456458802993406410752.0,
		4814598361444511.0 /   633825300114114700748351602688.0,
		6334877978873592.0 /   633825300114114700748351602688.0,
		5504850118309409.0 /   633825300114114700748351602688.0,
		8427379681253482.0 / 20282409603651670423947251286016.0,
		5819047581748367.0 /   633825300114114700748351602688.0,
		5286193807488183.0 /  5070602400912917605986812821504.0,
		7073254391049437.0 /  2535301200456458802993406410752.0,
		7299184050403205.0 /   633825300114114700748351602688.0,
		7704639836248887.0 /  5070602400912917605986812821504.0,
		5219173536869173.0 /  1267650600228229401496703205376.0,
		7700600499869997.0 /  1267650600228229401496703205376.0,
		5200862035022496.0 /   633825300114114700748351602688.0,
		4534919714861555.0 /  1267650600228229401496703205376.0,
		8034416082406136.0 /  1267650600228229401496703205376.0,
		6385154375859097.0 /   633825300114114700748351602688.0,
		7787423207959887.0 /  5070602400912917605986812821504.0,
		7918823589191826.0 /  1267650600228229401496703205376.0,
		5781790046876837.0 /   633825300114114700748351602688.0,
		8047772661635512.0 /  5070602400912917605986812821504.0,
		8648109030874835.0 /  1267650600228229401496703205376.0,
		7183725584551774.0 /  1267650600228229401496703205376.0,
		7269838508040587.0 / 81129638414606681695789005144064.0
	};

	template<>
	double const filib_consts<double>::q_lgb[2] =
	{
		6004799503155948.0 /          72057594037927936.0,
		7205779111987292.0 /         576460752303423488.0
	};

	template<>
	double const filib_consts<double>::q_lgc[4] =
	{
		6004799503160650.0 /          72057594037927936.0,
		7205759404556812.0 /         576460752303423488.0,
		5146967091902417.0 /        2305843009213693952.0,
		8019208851590178.0 /       18446744073709551616.0
	};

	template<>
	double const filib_consts<double>::q_lgld[129] =
	{
		0.0,
		8972197068537856.0 /        1152921504606846976.0,
		8937555034636288.0 /         576460752303423488.0,
		6677450211196928.0 /         288230376151711744.0,
		8869326752317440.0 /         288230376151711744.0,
		5522330335838208.0 /         144115188075855872.0,
		6601849900892160.0 /         144115188075855872.0,
		7673343223791616.0 /         144115188075855872.0,
		8736928775012352.0 /         144115188075855872.0,
		4896361210445824.0 /          72057594037927936.0,
		5420418749693952.0 /          72057594037927936.0,
		5940692447002624.0 /          72057594037927936.0,
		6457236551761920.0 /          72057594037927936.0,
		6970104154816512.0 /          72057594037927936.0,
		7479347221495808.0 /          72057594037927936.0,
		7985016623333376.0 /          72057594037927936.0,
		8487162167820288.0 /          72057594037927936.0,
		8985832628944896.0 /          72057594037927936.0,
		4740537887293440.0 /          36028797018963968.0,
		4986469197217792.0 /          36028797018963968.0,
		5230733163495424.0 /          36028797018963968.0,
		5473352242102272.0 /          36028797018963968.0,
		5714348438388736.0 /          36028797018963968.0,
		5953743319334912.0 /          36028797018963968.0,
		6191558024495104.0 /          36028797018963968.0,
		6427813277728768.0 /          36028797018963968.0,
		6662529397882880.0 /          36028797018963968.0,
		6895726309212160.0 /          36028797018963968.0,
		7127423551537152.0 /          36028797018963968.0,
		7357640290271232.0 /          36028797018963968.0,
		7586395325530112.0 /          36028797018963968.0,
		7813707101765632.0 /          36028797018963968.0,
		8039593716416512.0 /          36028797018963968.0,
		8264072928690176.0 /          36028797018963968.0,
		8487162167885824.0 /          36028797018963968.0,
		8708878541520896.0 /          36028797018963968.0,
		8929238843260928.0 /          36028797018963968.0,
		4574129780228096.0 /          18014398509481984.0,
		4682978440740864.0 /          18014398509481984.0,
		4791173351636992.0 /          18014398509481984.0,
		4898722318876672.0 /          18014398509481984.0,
		5005633009582080.0 /          18014398509481984.0,
		5111912955084800.0 /          18014398509481984.0,
		5217569554202624.0 /          18014398509481984.0,
		5322610076352512.0 /          18014398509481984.0,
		5427041664532480.0 /          18014398509481984.0,
		5530871338205184.0 /          18014398509481984.0,
		5634105996115968.0 /          18014398509481984.0,
		5736752419209216.0 /          18014398509481984.0,
		5838817273020416.0 /          18014398509481984.0,
		5940307110526976.0 /          18014398509481984.0,
		6041228374540288.0 /          18014398509481984.0,
		6141587400163328.0 /          18014398509481984.0,
		6241390417281024.0 /          18014398509481984.0,
		6340643552690176.0 /          18014398509481984.0,
		6439352832589824.0 /          18014398509481984.0,
		6537524184612864.0 /          18014398509481984.0,
		6635163439955968.0 /          18014398509481984.0,
		6732276335542272.0 /          18014398509481984.0,
		6828868516085760.0 /          18014398509481984.0,
		6924945535893504.0 /          18014398509481984.0,
		7020512860864512.0 /          18014398509481984.0,
		7115575870423040.0 /          18014398509481984.0,
		7210139859288064.0 /          18014398509481984.0,
		7304210039144448.0 /          18014398509481984.0,
		7397791540543488.0 /          18014398509481984.0,
		7490889414475776.0 /          18014398509481984.0,
		7583508633976832.0 /          18014398509481984.0,
		7675654095798272.0 /          18014398509481984.0,
		7767330621947904.0 /          18014398509481984.0,
		7858542961164288.0 /          18014398509481984.0,
		7949295790424064.0 /          18014398509481984.0,
		8039593716383744.0 /          18014398509481984.0,
		8129441276755968.0 /          18014398509481984.0,
		8218842941685760.0 /          18014398509481984.0,
		8307803115094016.0 /          18014398509481984.0,
		8396326136053760.0 /          18014398509481984.0,
		8484416279838720.0 /          18014398509481984.0,
		8572077759430656.0 /          18014398509481984.0,
		8659314726567936.0 /          18014398509481984.0,
		8746131272957952.0 /          18014398509481984.0,
		8832531431424000.0 /          18014398509481984.0,
		8918519177084928.0 /          18014398509481984.0,
		9004098428338176.0 /          18014398509481984.0,
		4544636524019712.0 /           9007199254740992.0,
		4587023422275584.0 /           9007199254740992.0,
		4629211786297344.0 /           9007199254740992.0,
		4671203467280384.0 /           9007199254740992.0,
		4713000290566144.0 /           9007199254740992.0,
		4754604056231936.0 /           9007199254740992.0,
		4796016539549696.0 /           9007199254740992.0,
		4837239491395584.0 /           9007199254740992.0,
		4878274638692352.0 /           9007199254740992.0,
		4919123684917248.0 /           9007199254740992.0,
		4959788310446080.0 /           9007199254740992.0,
		5000270172995584.0 /           9007199254740992.0,
		5040570908033024.0 /           9007199254740992.0,
		5080692129185792.0 /           9007199254740992.0,
		5120635428585472.0 /           9007199254740992.0,
		5160402377310208.0 /           9007199254740992.0,
		5199994525696000.0 /           9007199254740992.0,
		5239413403729920.0 /           9007199254740992.0,
		5278660521394176.0 /           9007199254740992.0,
		5317737369042944.0 /           9007199254740992.0,
		5356645417680896.0 /           9007199254740992.0,
		5395386119356416.0 /           9007199254740992.0,
		5433960907472896.0 /           9007199254740992.0,
		5472371197034496.0 /           9007199254740992.0,
		5510618385104896.0 /           9007199254740992.0,
		5548703850954752.0 /           9007199254740992.0,
		5586628956471296.0 /           9007199254740992.0,
		5624395046420480.0 /           9007199254740992.0,
		5662003448676352.0 /           9007199254740992.0,
		5699455474581504.0 /           9007199254740992.0,
		5736752419192832.0 /           9007199254740992.0,
		5773895561543680.0 /           9007199254740992.0,
		5810886164889600.0 /           9007199254740992.0,
		5847725477003264.0 /           9007199254740992.0,
		5884414730387456.0 /           9007199254740992.0,
		5920955142602752.0 /           9007199254740992.0,
		5957347916365824.0 /           9007199254740992.0,
		5993594239942656.0 /           9007199254740992.0,
		6029695287296000.0 /           9007199254740992.0,
		6065652218298368.0 /           9007199254740992.0,
		6101466179010560.0 /           9007199254740992.0,
		6137138301894656.0 /           9007199254740992.0,
		6172669705977856.0 /           9007199254740992.0,
		6208061497114624.0 /           9007199254740992.0,
		6243314768166912.0 /           9007199254740992.0
	};

	template<>
	double const filib_consts<double>::q_lgtl[129] =
	{
		0.0,
		-8779523165335033.0 / 9903520314283042199192993792.0,
		-8972983448710233.0 / 19807040628566084398385987584.0,
		-5197574919181724.0 / 9903520314283042199192993792.0,
		7177777203513828.0 / 158456325028528675187087900672.0,
		-5675702375042557.0 / 9903520314283042199192993792.0,
		-5119582170830305.0 / 9903520314283042199192993792.0,
		6504625575382142.0 / 9903520314283042199192993792.0,
		6239067461949207.0 / 9903520314283042199192993792.0,
		-4683794773998872.0 / 9903520314283042199192993792.0,
		-6499997923034360.0 / 39614081257132168796771975168.0,
		6825120308815978.0 / 79228162514264337593543950336.0,
		-5232079825324226.0 / 9903520314283042199192993792.0,
		-7098183277802855.0 / 19807040628566084398385987584.0,
		7507931960067412.0 / 9903520314283042199192993792.0,
		-7985156303620159.0 / 39614081257132168796771975168.0,
		8546217148612604.0 / 9903520314283042199192993792.0,
		-5987209403328007.0 / 79228162514264337593543950336.0,
		-7997462545670512.0 / 9903520314283042199192993792.0,
		7292005164063289.0 / 9903520314283042199192993792.0,
		-6114830641995260.0 / 79228162514264337593543950336.0,
		-7919718041800360.0 / 9903520314283042199192993792.0,
		8804450843382846.0 / 9903520314283042199192993792.0,
		-5332731370113607.0 / 9903520314283042199192993792.0,
		-7611978642587006.0 / 9903520314283042199192993792.0,
		-6458227797840346.0 / 19807040628566084398385987584.0,
		-5483754353748299.0 / 19807040628566084398385987584.0,
		-7731456260144961.0 / 19807040628566084398385987584.0,
		6101316997487950.0 / 9903520314283042199192993792.0,
		-5250415826015201.0 / 9903520314283042199192993792.0,
		-4507215124232626.0 / 9903520314283042199192993792.0,
		-8103905381342652.0 / 9903520314283042199192993792.0,
		-7168356092868675.0 / 9903520314283042199192993792.0,
		-4815487732852354.0 / 9903520314283042199192993792.0,
		-7375713698054204.0 / 79228162514264337593543950336.0,
		6277749789922574.0 / 9903520314283042199192993792.0,
		8749117532747292.0 / 19807040628566084398385987584.0,
		-6719745017649061.0 / 9903520314283042199192993792.0,
		4753598734376984.0 / 19807040628566084398385987584.0,
		-7482673504168538.0 / 9903520314283042199192993792.0,
		5355728896518841.0 / 9903520314283042199192993792.0,
		7312833692726592.0 / 19807040628566084398385987584.0,
		-7434309047355747.0 / 79228162514264337593543950336.0,
		7473908048204784.0 / 79228162514264337593543950336.0,
		8216221649017477.0 / 19807040628566084398385987584.0,
		-6009165327990930.0 / 158456325028528675187087900672.0,
		-8174990963054918.0 / 9903520314283042199192993792.0,
		5613962591289082.0 / 9903520314283042199192993792.0,
		-4678153444418598.0 / 9903520314283042199192993792.0,
		-8299744281155620.0 / 79228162514264337593543950336.0,
		-8809119037947073.0 / 79228162514264337593543950336.0,
		-5288469243140857.0 / 9903520314283042199192993792.0,
		5511444222975716.0 / 39614081257132168796771975168.0,
		-7940021354000045.0 / 9903520314283042199192993792.0,
		5821657490788373.0 / 19807040628566084398385987584.0,
		4769432497392748.0 / 9903520314283042199192993792.0,
		-6751764000396803.0 / 9903520314283042199192993792.0,
		-7932709923118083.0 / 9903520314283042199192993792.0,
		6722080591770586.0 / 9903520314283042199192993792.0,
		6243656070122434.0 / 39614081257132168796771975168.0,
		-8675856158539640.0 / 9903520314283042199192993792.0,
		-8224904928701078.0 / 19807040628566084398385987584.0,
		6468127548052605.0 / 19807040628566084398385987584.0,
		-8854591933322168.0 / 19807040628566084398385987584.0,
		6838905257948783.0 / 19807040628566084398385987584.0,
		8309103832292231.0 / 9903520314283042199192993792.0,
		4665341932202590.0 / 39614081257132168796771975168.0,
		-8536312763045801.0 / 79228162514264337593543950336.0,
		8660962577700307.0 / 39614081257132168796771975168.0,
		4779961708793737.0 / 19807040628566084398385987584.0,
		7736127408388012.0 / 19807040628566084398385987584.0,
		6375766642173373.0 / 9903520314283042199192993792.0,
		7355372647489267.0 / 19807040628566084398385987584.0,
		-6800518167423654.0 / 39614081257132168796771975168.0,
		-5676358184678420.0 / 19807040628566084398385987584.0,
		6648919294333302.0 / 9903520314283042199192993792.0,
		-8355878418558385.0 / 9903520314283042199192993792.0,
		-5587594652990059.0 / 19807040628566084398385987584.0,
		8478943888653555.0 / 79228162514264337593543950336.0,
		7177812592863207.0 / 39614081257132168796771975168.0,
		7796419822797900.0 / 79228162514264337593543950336.0,
		5724266422476379.0 / 9903520314283042199192993792.0,
		-7250508785399339.0 / 39614081257132168796771975168.0,
		-6420412667761511.0 / 39614081257132168796771975168.0,
		4783728608501119.0 / 9903520314283042199192993792.0,
		-7087013920440181.0 / 9903520314283042199192993792.0,
		8796429499119761.0 / 9903520314283042199192993792.0,
		-6120490536719873.0 / 19807040628566084398385987584.0,
		-6048728731894988.0 / 9903520314283042199192993792.0,
		7063184679353645.0 / 19807040628566084398385987584.0,
		7087433830708759.0 / 19807040628566084398385987584.0,
		-4578009916696120.0 / 9903520314283042199192993792.0,
		6167888972194710.0 / 9903520314283042199192993792.0,
		7213619939798944.0 / 9903520314283042199192993792.0,
		5310197597449968.0 / 19807040628566084398385987584.0,
		-8684060280396034.0 / 79228162514264337593543950336.0,
		7326860060180092.0 / 316912650057057350374175801344.0,
		-5790495037124746.0 / 9903520314283042199192993792.0,
		-6667044333231015.0 / 316912650057057350374175801344.0,
		-4619632321907294.0 / 19807040628566084398385987584.0,
		-8385052027225229.0 / 19807040628566084398385987584.0,
		-8702012943394996.0 / 19807040628566084398385987584.0,
		8188556832433012.0 / 19807040628566084398385987584.0,
		5420603616801937.0 / 79228162514264337593543950336.0,
		4712643026788853.0 / 9903520314283042199192993792.0,
		8287233976481403.0 / 9903520314283042199192993792.0,
		-8493628883019642.0 / 9903520314283042199192993792.0,
		8680745032294675.0 / 39614081257132168796771975168.0,
		-6164232554782665.0 / 9903520314283042199192993792.0,
		-8702099962065875.0 / 79228162514264337593543950336.0,
		6468031838829835.0 / 9903520314283042199192993792.0,
		-4712114675691427.0 / 9903520314283042199192993792.0,
		-7497806927788567.0 / 19807040628566084398385987584.0,
		8108850556647106.0 / 19807040628566084398385987584.0,
		8658091620644787.0 / 9903520314283042199192993792.0,
		4994976833435232.0 / 19807040628566084398385987584.0,
		-5717312355927441.0 / 158456325028528675187087900672.0,
		-5003115448443598.0 / 9903520314283042199192993792.0,
		7794011395348038.0 / 9903520314283042199192993792.0,
		-6637426164737269.0 / 9903520314283042199192993792.0,
		6381264288529495.0 / 39614081257132168796771975168.0,
		5796251996162884.0 / 9903520314283042199192993792.0,
		-6981339538248084.0 / 19807040628566084398385987584.0,
		-7277932480727476.0 / 39614081257132168796771975168.0,
		8775181525493232.0 / 9903520314283042199192993792.0,
		6584481064666583.0 / 9903520314283042199192993792.0,
		6321576975359954.0 / 9903520314283042199192993792.0,
		4980327996109847.0 / 19807040628566084398385987584.0,
		-6829247562655284.0 / 39614081257132168796771975168.0
	};

	template<>
	double const filib_consts<double>::q_sinc[6] =
	{
		6004799503160652.0 /         144115188075855872.0,
		-6405119470031391.0 /        4611686018427387904.0,
		7320136533669489.0 /      295147905179352825856.0,
		-5205429515405659.0 /    18889465931478580854784.0,
		5047441620321680.0 /  2417851639229258349412352.0,
		-7031457305697611.0 / 618970019642690137449562112.0
	};

	template<>
	double const filib_consts<double>::q_sins[6] =
	{
		-6004799503160666.0 /          36028797018963968.0,
		4803839602527639.0 /         576460752303423488.0,
		-7320136535288236.0 /       36893488147419103232.0,
		6506787178212600.0 /     2361183241434822606848.0,
		-7571207865408408.0 /   302231454903657293676544.0,
		6155219321001458.0 / 38685626227668133590597632.0
	};

	template<>
	double const filib_consts<double>::q_sint[5] =
	{
		4704863629888981.0 /  9007199254740992.0,
		4600683640854786.0 /   18014398509481984.0,
		7074237750381340.0 /  2097152.0,
		7800291619608491.0 /   302231454903657293676544.0, 
		5515724051991746.0 /   302231454903657293676544.0
	};
}
