
/*
 * IBM Accurate Mathematical Library
 * Copyright (c) International Business Machines Corp., 2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */
/******************************************************************/
/*                                                                */
/* MODULE_NAME:mpexp.h                                            */
/*                                                                */
/* common data and variables prototype and definition             */
/******************************************************************/

#ifndef MPEXP_H
#define MPEXP_H

#ifdef BIG_ENDI
  static const number
        twomm1[33] = {                            /* 2**-m1 */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x3ee00000, 0x00000000 }, /* 2**-17 */
/**/                  {0x3e800000, 0x00000000 }, /* 2**-23 */
/**/                  {0x3e800000, 0x00000000 }, /* 2**-23 */
/**/                  {0x3e300000, 0x00000000 }, /* 2**-28 */
/**/                  {0x3e400000, 0x00000000 }, /* 2**-27 */
/**/                  {0x3d900000, 0x00000000 }, /* 2**-38 */
/**/                  {0x3d500000, 0x00000000 }, /* 2**-42 */
/**/                  {0x3d800000, 0x00000000 }, /* 2**-39 */
/**/                  {0x3d400000, 0x00000000 }, /* 2**-43 */
/**/                  {0x3d000000, 0x00000000 }, /* 2**-47 */
/**/                  {0x3d400000, 0x00000000 }, /* 2**-43 */
/**/                  {0x3d000000, 0x00000000 }, /* 2**-47 */
/**/                  {0x3cd00000, 0x00000000 }, /* 2**-50 */
/**/                  {0x3c900000, 0x00000000 }, /* 2**-54 */
/**/                  {0x3c600000, 0x00000000 }, /* 2**-57 */
/**/                  {0x3c300000, 0x00000000 }, /* 2**-60 */
/**/                  {0x3bf00000, 0x00000000 }, /* 2**-64 */
/**/                  {0x3bc00000, 0x00000000 }, /* 2**-67 */
/**/                  {0x3b800000, 0x00000000 }, /* 2**-71 */
/**/                  {0x3b500000, 0x00000000 }, /* 2**-74 */
/**/                  {0x3bb00000, 0x00000000 }, /* 2**-68 */
/**/                  {0x3b800000, 0x00000000 }, /* 2**-71 */
/**/                  {0x3b500000, 0x00000000 }, /* 2**-74 */
/**/                  {0x3b200000, 0x00000000 }, /* 2**-77 */
/**/                  {0x3b900000, 0x00000000 }, /* 2**-70 */
/**/                  {0x3b600000, 0x00000000 }, /* 2**-73 */
/**/                  {0x3b300000, 0x00000000 }, /* 2**-76 */
/**/                  {0x3b100000, 0x00000000 }, /* 2**-78 */
/**/                  {0x3ae00000, 0x00000000 }, /* 2**-81 */
  };
  static const number
               nn[9]={                            /* n      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x3ff00000, 0x00000000 }, /* 1      */
/**/                  {0x40000000, 0x00000000 }, /* 2      */
/**/                  {0x40080000, 0x00000000 }, /* 3      */
/**/                  {0x40100000, 0x00000000 }, /* 4      */
/**/                  {0x40140000, 0x00000000 }, /* 5      */
/**/                  {0x40180000, 0x00000000 }, /* 6      */
/**/                  {0x401c0000, 0x00000000 }, /* 7      */
/**/                  {0x40200000, 0x00000000 }, /* 8      */
  };

  static const number
/**/ radix          = {0x41700000, 0x00000000 }, /* 2**24  */
/**/ radixi         = {0x3e700000, 0x00000000 }, /* 2**-24 */
/**/ zero           = {0x00000000, 0x00000000 }, /* 0      */
/**/ one            = {0x3ff00000, 0x00000000 }, /* 1      */
/**/ two            = {0x40000000, 0x00000000 }, /* 2      */
/**/ half           = {0x3fe00000, 0x00000000 }; /* 1/2    */

#else
#ifdef LITTLE_ENDI
  static const number
        twomm1[33] = {                            /* 2**-m1 */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x3ee00000 }, /* 2**-17 */
/**/                  {0x00000000, 0x3e800000 }, /* 2**-23 */
/**/                  {0x00000000, 0x3e800000 }, /* 2**-23 */
/**/                  {0x00000000, 0x3e300000 }, /* 2**-28 */
/**/                  {0x00000000, 0x3e400000 }, /* 2**-27 */
/**/                  {0x00000000, 0x3d900000 }, /* 2**-38 */
/**/                  {0x00000000, 0x3d500000 }, /* 2**-42 */
/**/                  {0x00000000, 0x3d800000 }, /* 2**-39 */
/**/                  {0x00000000, 0x3d400000 }, /* 2**-43 */
/**/                  {0x00000000, 0x3d000000 }, /* 2**-47 */
/**/                  {0x00000000, 0x3d400000 }, /* 2**-43 */
/**/                  {0x00000000, 0x3d000000 }, /* 2**-47 */
/**/                  {0x00000000, 0x3cd00000 }, /* 2**-50 */
/**/                  {0x00000000, 0x3c900000 }, /* 2**-54 */
/**/                  {0x00000000, 0x3c600000 }, /* 2**-57 */
/**/                  {0x00000000, 0x3c300000 }, /* 2**-60 */
/**/                  {0x00000000, 0x3bf00000 }, /* 2**-64 */
/**/                  {0x00000000, 0x3bc00000 }, /* 2**-67 */
/**/                  {0x00000000, 0x3b800000 }, /* 2**-71 */
/**/                  {0x00000000, 0x3b500000 }, /* 2**-74 */
/**/                  {0x00000000, 0x3bb00000 }, /* 2**-68 */
/**/                  {0x00000000, 0x3b800000 }, /* 2**-71 */
/**/                  {0x00000000, 0x3b500000 }, /* 2**-74 */
/**/                  {0x00000000, 0x3b200000 }, /* 2**-77 */
/**/                  {0x00000000, 0x3b900000 }, /* 2**-70 */
/**/                  {0x00000000, 0x3b600000 }, /* 2**-73 */
/**/                  {0x00000000, 0x3b300000 }, /* 2**-76 */
/**/                  {0x00000000, 0x3b100000 }, /* 2**-78 */
/**/                  {0x00000000, 0x3ae00000 }, /* 2**-81 */
  };
  static const number
               nn[9]={                            /* n      */
/**/                  {0x00000000, 0x00000000 }, /* 0      */
/**/                  {0x00000000, 0x3ff00000 }, /* 1      */
/**/                  {0x00000000, 0x40000000 }, /* 2      */
/**/                  {0x00000000, 0x40080000 }, /* 3      */
/**/                  {0x00000000, 0x40100000 }, /* 4      */
/**/                  {0x00000000, 0x40140000 }, /* 5      */
/**/                  {0x00000000, 0x40180000 }, /* 6      */
/**/                  {0x00000000, 0x401c0000 }, /* 7      */
/**/                  {0x00000000, 0x40200000 }, /* 8      */
  };

  static const number
/**/ radix          = {0x00000000, 0x41700000 }, /* 2**24  */
/**/ radixi         = {0x00000000, 0x3e700000 }, /* 2**-24 */
/**/ zero           = {0x00000000, 0x00000000 }, /* 0      */
/**/ one            = {0x00000000, 0x3ff00000 }, /* 1      */
/**/ two            = {0x00000000, 0x40000000 }, /* 2      */
/**/ half           = {0x00000000, 0x3fe00000 }; /* 1/2    */

#endif
#endif

#define  RADIX     radix.d
#define  RADIXI    radixi.d
#define  ZERO      zero.d
#define  ONE       one.d
#define  TWO       two.d
#define  HALF      half.d

#endif
